//
//  RMURLConnectionOperation.h
//  RMFoundation
//
//  Created by Damien DeVille on 10/04/2012.
//  Copyright (c) 2012 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface RMURLConnectionOperation : NSOperation

- (id)initWithRequest:(NSURLRequest *)request;

@property (readonly, copy, nonatomic) NSURLRequest *request;
@property (readonly, copy, nonatomic) NSURLRequest *currentRequest;
@property (readonly, copy, nonatomic) NSURLResponse *response;

@property (readonly, retain, nonatomic) NSError *connectionError;

/*!
	\brief
	If no output stream is provided, a default one writing to memory will be created. You can retrieve the data on completion with -propertyForKey:NSStreamDataWrittenToMemoryStreamKey on the stream.
 */
@property (retain, nonatomic) NSOutputStream *outputStream;

/*!
	\brief
	You should not rely on the response provider if you provide your own output stream since it will return nil.
 */
typedef NSData * (^RMURLConnectionOperationResponseProvider)(NSURLResponse **, NSError **);
@property (readonly, copy, nonatomic) RMURLConnectionOperationResponseProvider responseProvider;

typedef void (^RMURLConnectionOperationAuthenticationChallengeHandler) (NSURLAuthenticationChallenge *challenge);
@property (copy, nonatomic) RMURLConnectionOperationAuthenticationChallengeHandler authenticationChallengeHandler;

/*!
	\brief
	Examine the new request and the response that caused the redirect, then do one of the following:
	- Allow the redirect by simply returning the provided request
	- Create a new request, pointing to a different URL, and return that request
	- Reject the redirect and receive any existing data from the connection by returning nil
 */
typedef NSURLRequest * (^RMURLConnectionOperationRedirectHandler) (NSURLRequest *request, NSURLResponse *redirectResponse);
@property (copy, nonatomic) RMURLConnectionOperationRedirectHandler redirectHandler;

/*!
	\brief
	Returning NO will cancel the connection and the operation.
 */
typedef BOOL (^RMURLConnectionOperationResponseHandler) (NSURLResponse *response);
@property (copy, nonatomic) RMURLConnectionOperationResponseHandler responseHandler;

typedef void (^RMURLConnectionOperationDownloadProgressHandler) (NSInteger bytesRead, NSInteger totalBytesRead, NSInteger totalBytesExpectedToRead);
@property (copy, nonatomic) RMURLConnectionOperationDownloadProgressHandler downloadProgressHandler;

typedef void (^RMURLConnectionOperationUploadProgressHandler) (NSInteger bytesWritten, NSInteger totalBytesWritten, NSInteger totalBytesExpectedToWrite);
@property (copy, nonatomic) RMURLConnectionOperationUploadProgressHandler uploadProgressHandler;

@end
